package org.areco.ecommerce.cmstraining.restrictions;

import de.hybris.platform.cms2.servicelayer.data.RestrictionData;
import de.hybris.platform.cms2.servicelayer.services.evaluator.CMSRestrictionEvaluator;
import de.hybris.platform.core.model.order.AbstractOrderEntryModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.order.CartService;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.areco.ecommerce.cmstraining.model.UndecidedShoppingCustomerRestrictionModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by arobirosa on 06.12.14.
 */
@Component
public class UndecidedShoppingCustomerRestrictionEvaluator implements CMSRestrictionEvaluator<UndecidedShoppingCustomerRestrictionModel>
{
  /*
    Logger of this class.
   */
  private static final Logger LOG = Logger.getLogger(UndecidedShoppingCustomerRestrictionEvaluator.class);

  @Autowired
  private CartService cartService;

  @Override public boolean evaluate(final UndecidedShoppingCustomerRestrictionModel pUndecidedShoppingCustomerRestrictionModel,
      final RestrictionData pRestrictionData)
  {
    CartModel cart = cartService.getSessionCart();
    if (cart.getEntries().isEmpty()) {
      return false;
    } else {
      //It is safe to use dates, because all the entries have the same time zone.
      Date newestModifiedTime = null;
      for (AbstractOrderEntryModel anEntry : cart.getEntries()) {
        if (newestModifiedTime == null || newestModifiedTime.compareTo(anEntry.getModifiedtime()) > 0)
        {
          newestModifiedTime = anEntry.getModifiedtime();
        }
      }
      Calendar now = Calendar.getInstance();

      Calendar timeLimit = Calendar.getInstance();
      timeLimit.setTime(newestModifiedTime);
      timeLimit.set(Calendar.MINUTE, pUndecidedShoppingCustomerRestrictionModel.getTimeToWaitInMinutes());
      final boolean resutlEvaluation = now.after(timeLimit);
      if (LOG.isDebugEnabled())
      {
        LOG.debug("Result of evaluation of " + pUndecidedShoppingCustomerRestrictionModel.getUid() + ": " + resutlEvaluation);
      }
      return resutlEvaluation;
    }
  }
}
