package org.areco.ecommerce.cmstraining.attributehandlers;

import de.hybris.platform.servicelayer.model.attribute.DynamicAttributeHandler;
import de.hybris.platform.util.localization.Localization;
import org.areco.ecommerce.cmstraining.model.UndecidedShoppingCustomerRestrictionModel;
import org.springframework.stereotype.Component;

/**
 * Created by arobirosa on 06.12.14.
 */
@Component
public class UndecidedShoppingCustomerRestrictionDynamicDescription implements DynamicAttributeHandler<String, UndecidedShoppingCustomerRestrictionModel>
{

  public static final String KEY_DESCRIPTION_TEXT = "type.UndecidedShoppingCustomerRestriction.description.text";

  @Override public String get(final UndecidedShoppingCustomerRestrictionModel pModel)
  {
    return Localization.getLocalizedString(KEY_DESCRIPTION_TEXT,
        new Object[] { pModel.getTimeToWaitInMinutes()});
  }

  @Override public void set(final UndecidedShoppingCustomerRestrictionModel pUndecidedShoppingCustomerRestrictionModel,
      final String s)
  {
    throw new UnsupportedOperationException();
  }
}
